#pragma once

#include <ymod_taskmaster/types.hpp>
#include <yplatform/module.h>
#include <boost/optional.hpp>
#include <ymod_taskmaster/context.hpp>
#include <ymod_taskmaster/task.hpp>
#include <pgg/request_info.h>
#include <internal/config.hpp>

namespace ymod_taskmaster {

class Service : public yplatform::module {
public:
    using Result = boost::optional<TaskGroupId>;

    virtual Result planTaskIfAsync(TaskPtr task, const size_t midsCount,
                                   ContextPtr context, YieldCtx yieldCtx) = 0;
    virtual Result planTaskIfAsync(TaskPtr task, const Mids& mids,
                                   ContextPtr context, YieldCtx yieldCtx) = 0;
    virtual TaskGroupId planTask(TaskPtr task, const Mids& mids,
                                 ContextPtr context, YieldCtx yieldCtx) = 0;
    virtual TaskStatParams readTask(const UserId& uid, const TaskId& taskId,
                                    ContextPtr context, YieldCtx yieldCtx) = 0;

    //Get chunk for work and call handler for data inside.
    virtual bool getChunk(ChunkHandler handler, ContextPtr context,
                          const std::string& launchId, YieldCtx yieldCtx) = 0;

    virtual UserStat getUserStat(const std::string& uid,
                                 ContextPtr context, YieldCtx yieldCtx) = 0;

    virtual const QueueSettings& getQueueSettings() const = 0;
};

using ServicePtr = std::shared_ptr<Service>;

}
