#include <ymod_taskmaster/marshalling.hpp>
#include <internal/chunks_repository_impl.hpp>

namespace ymod_taskmaster {

ChunksRepositoryImpl::ChunksRepositoryImpl(RepositoryPtr pgRequest, ContextPtr context,
                                           const size_t pgRetries, Milliseconds pgRetryDelay,
                                           Seconds chunkTtl)
    : logger(getContextLogger(context))
    , context(context)
    , pgRepo(pgRequest, context, pgRetries, pgRetryDelay, chunkTtl)
{}

ChunkPathInfo formChunkPathInfo(const std::string& chunkNodeName, const UserId& uid) {
    return ChunkPathInfo(uid, chunkNodeName);
}

ProcessChunkResult ChunksRepositoryImpl::processChunk(const User& user, const ChunkId& chunkId, ChunkHandler handler,
                                                      YieldCtx yieldCtx) {
    try {
        return pgRepo.processChunk(user, chunkId, handler, yieldCtx);
    } catch (const std::exception& e) {
        LOGDOG_(logger, error, log::message="can't process chunk", log::chunk_id=chunkId, log::exception=e);
        return Chunk();
    }
}

ChunkIds ChunksRepositoryImpl::chooseChunkIds(const User& user, size_t limit, YieldCtx yieldCtx) {
    return pgRepo.chooseChunkIds(user, limit, yieldCtx);
}

}
