
#include <pa/async.h>
#include <internal/logger.hpp>
#include <boost/range/adaptor/filtered.hpp>
#include <boost/scope_exit.hpp>

namespace ymod_taskmaster {
namespace {

uint32_t toMillisecondsCount(const pgg::Duration duration) {
    const auto ms = std::chrono::duration_cast<pgg::Milliseconds>(duration);
    return static_cast<uint32_t>(ms.count());
}

} // namespace

PgPaProfiler::PgPaProfiler(ContextPtr context)
    : context(std::move(context))
{}

void PgPaProfiler::write(const std::string& operation, const std::string&, pgg::Duration duration) const {
    pa::async_profiler::add(pa::postgresql, "pgg", operation, context->uniq_id(), toMillisecondsCount(duration));
}

} // namespace ymod_taskmaster
