#include <ymod_taskmaster/marshalling.hpp>

#include <boost/algorithm/string.hpp>
#include <yamail/data/serialization/json_writer.h>
#include <yamail/data/deserialization/json_reader.h>

BOOST_FUSION_DEFINE_STRUCT((ymod_taskmaster), MinimalTaskInfo,
    (ymod_taskmaster::OptVersion, version)
    (size_t, creationSecs)
    (size_t, chunksCount)
)

namespace ymod_taskmaster {

std::string toString(const ChunkData& data) {
    return yamail::data::serialization::toJson(data).str();
}

std::string toString(const TaskInfo& taskInfo) {
    return yamail::data::serialization::toJson(taskInfo).str();
}

inline TaskInfo makeMinimalTaskInfo(const boost::property_tree::ptree& ptree) {
    auto minimal = yamail::data::deserialization::fromPtree<MinimalTaskInfo>(ptree);
    TaskInfo info;
    info.version = minimal.version;
    info.chunksCount = minimal.chunksCount;
    info.creationSecs = minimal.creationSecs;
    return info;
}

TaskInfo makeTaskInfo(const std::string& str) {
    const auto ptree = yamail::data::deserialization::json::toPtree(str);
    const auto version = ptree.get_optional<Version>("version");
    if (version == dataVersion) {
        return yamail::data::deserialization::fromPtree<TaskInfo>(ptree);
    } else {
        return makeMinimalTaskInfo(ptree);
    }
}

std::string toString(const ChunkInfo& info) {
    return yamail::data::serialization::toJson<ChunkInfo>(info).str();
}

ChunkInfo makeChunkInfo(const std::string& str) {
    return yamail::data::deserialization::fromJson<ChunkInfo>(str);
}

std::string toString(const ChunksInfo& info) {
    return yamail::data::serialization::toJson(info).str();
}

ChunksInfo makeChunksInfo(const std::string& str) {
    return yamail::data::deserialization::fromJson<ChunksInfo>(str);
}

std::string toString(const Mids& mids) {
    std::vector<std::string> midsStr(mids.size());
    boost::transform(mids, midsStr.begin(), boost::lexical_cast<std::string, Mid>);
    return boost::algorithm::join(midsStr, ",");
}

std::string toString(const TaskStatParams& task) {
    return yamail::data::serialization::toJson(task).str();
}

std::string toString(const UserStat& stat) {
    return yamail::data::serialization::toJson(stat).str();
}

std::string toShortString(const Mids& mids) {
    std::list<std::string> midsStr(mids.size());
    boost::transform(mids, midsStr.begin(), boost::lexical_cast<std::string, Mid>);
    return toShortString(midsStr);
}

std::string toShortString(const std::list<std::string>& mids) {
    const size_t midsLogThreshold = 1000;
    return mids.size() > midsLogThreshold
        ? mids.front() + ",...," + mids.back()
        : boost::algorithm::join(mids, ",");
}

}
