
#include <internal/notify.hpp>
#include <butil/http/codes.h>
#include <ymod_taskmaster/marshalling.hpp>

namespace ymod_taskmaster {

void fillTaskParams(TaskStatParams& task, const Chunk& chunk) {
    task.setTaskId(chunk.task.id());
    task.setTaskGroupId(chunk.task.taskGroupId());
    task.setType(chunk.task.taskData.type);
    task.setCreationTimestamp(chunk.task.creationSecs);
    task.setRemainedChunksCount(0);
    task.setTotalChunksCount(chunk.task.chunksCount);
}

void Notifier::notify(const User& user, const Chunk& chunk, YieldCtx yieldCtx) {
    const TaskInfo& task = chunk.task;
    try {
        TaskStatParams taskParams = tasksRepo_->readTask(user, task.id(), yieldCtx);
        if (!isValid(taskParams)) {
            fillTaskParams(taskParams, chunk);
        }

        HttpArguments args;
        args.add("stoken", settings_.stoken);
        args.add("uid", user.uid());

        auto& client = settings_.httpClient;

        using namespace http_getter::detail::operators;
        auto req = client->toPOST(settings_.endpoint)
            .getArgs("args"_arg=std::move(args))
            .body(toString(taskParams) + "\r\n");

        http_getter::Handler handler = {
            .success = [](auto) {return http_getter::Result::success;}
        };
        handler.error = [&](auto ec) {
            LOGDOG_(logger_, error, log::message="notify hub responded with",
                    log::uid=user.uid(), log::task_id=task.id(), log::chunk_id=chunk.chunk.id,
                    log::error_code=ec);
        };

        client->req(std::move(req))->call("notify", std::move(handler), io_result::make_yield_context(yieldCtx));
    } catch (const std::exception& e) {
        LOGDOG_(logger_, error, log::message="exception",
                log::uid=user.uid(), log::task_id=task.id(), log::chunk_id=chunk.chunk.id,
                log::exception=e);
    }
}

}
