#include <internal/queue.hpp>
#include <internal/queue_impl.hpp>
#include <internal/users_repository_impl.hpp>
#include <internal/tasks_repository.hpp>
#include <internal/chunks_repository_impl.hpp>
#include <internal/notify.hpp>

namespace ymod_taskmaster {

QueuePtr getQueue(const QueueSettings& settings, RepositoryPtr pgRequest,
                  ContextPtr context,
                  const NotifySettings& notifySettings) {

    UsersRepositoryPtr usersRepo = boost::make_shared<UsersRepositoryImpl>(pgRequest, settings.lock_timeout, context);
    ChunksRepositoryPtr chunksRepo(boost::make_shared<ChunksRepositoryImpl>(pgRequest, context,
        settings.pg_retries, settings.pg_retry_delay, boost::chrono::duration_cast<Seconds>(settings.chunk_ttl_days)));
    TasksRepositoryPtr tasksRepo = boost::make_shared<TasksRepositoryImpl>(
        pgRequest, context, settings.chunk_size, settings.tasks_limit);
    NotifierPtr notifier = boost::make_shared<Notifier>(tasksRepo, context, notifySettings);

    return boost::make_shared<QueueImpl>(settings, usersRepo, chunksRepo, tasksRepo, context, notifier);
}
}
