#include <ymod_taskmaster/marshalling.hpp>
#include <internal/tasks_storage_pg.hpp>

namespace ymod_taskmaster {

TasksStoragePg::TasksStoragePg(RepositoryPtr pgRequest, ContextPtr context)
    : pgRequest_(std::move(pgRequest)), context_(std::move(context))
{}

void TasksStoragePg::pushTask(const User& user, const ChunksData& chunksData, const TaskInfo& taskInfo,
                              YieldCtx yieldCtx) {
    pgRequest_->addTask(user, chunksData, taskInfo, context_, io_result::make_yield_context(yieldCtx));
}

bool TasksStoragePg::canPushTask(const User& user, size_t tasksLimit, YieldCtx yieldCtx) {
    return pgRequest_->canAddTask(user, tasksLimit, context_, io_result::make_yield_context(yieldCtx));
}

bool TasksStoragePg::hasTasks(const User& user, YieldCtx yieldCtx) const {
    return pgRequest_->hasTasks(user, context_, io_result::make_yield_context(yieldCtx));
}

TaskStatParams TasksStoragePg::readTask(const User& user, const TaskId& taskId, YieldCtx yieldCtx) {
    TasksStatParams tasks = fromSequence<TasksStatParams>(
        pgRequest_->readTask(user, taskId, context_, io_result::make_yield_context(yieldCtx))
    );
    return tasks.empty() ? TaskStatParams() : tasks.front();
}

} // namespace
