#include <internal/users_repository_impl.hpp>

namespace ymod_taskmaster {

Users UsersRepositoryImpl::chooseUsers(size_t limit, YieldCtx yieldCtx) {
    return pgRepo.chooseUsers(limit, yieldCtx);
}

UserStat UsersRepositoryImpl::userStat(const UserId& uid, YieldCtx yieldCtx) {
    return pgRepo.userStat(User(uid), yieldCtx);
}

bool UsersRepositoryImpl::tryWorkerLock(const User& user, const std::string& launchId, YieldCtx yieldCtx) {
    try {
        return pgRepo.lockUser(user, lockTimeout, launchId, yieldCtx);
    } catch (const std::exception& e) {
        LOGDOG_(logger_, debug, log::message="unexpected exception in user lock",
                log::uid=user.uid(), log::ttl=lockTimeout, log::launch_id=launchId, log::exception=e);
        return false;
    } catch (...) {
        LOGDOG_(logger_, debug, log::message="unexpected error in user lock",
                log::uid=user.uid(), log::ttl=lockTimeout, log::launch_id=launchId);
        return false;
    }
}

void UsersRepositoryImpl::unlockWorker(const User& user, const std::string& launchId, YieldCtx yieldCtx) {
    try {
        pgRepo.unlockUser(user, launchId, yieldCtx);
    } catch (const std::exception& e) {
        LOGDOG_(logger_, debug, log::message="unexpected exception in user unlock",
                log::uid=user.uid(), log::launch_id=launchId, log::exception=e);
    } catch (...) {
        LOGDOG_(logger_, debug, log::message="unexpected error in user lock",
                log::uid=user.uid(), log::launch_id=launchId);
    }
}

}
