#pragma once

#include <mail/pgg/include/pgg/query/ids.h>
#include <mail/pgg/include/pgg/query/boundaries.h>
#include <mail/pgg/include/pgg/query/query_register.h>

#include "reflection.h"

PGG_QUERY_ID((ymod_taskmaster)(query), UserId, std::string)
PGG_QUERY_ID((ymod_taskmaster)(query), TaskId, boost::uuids::uuid)
PGG_QUERY_ID((ymod_taskmaster)(query), TaskInfo, std::string)
PGG_QUERY_ID((ymod_taskmaster)(query), ChunksInfo, std::string)
PGG_QUERY_ID((ymod_taskmaster)(query), Limit, std::size_t)
PGG_QUERY_ID((ymod_taskmaster)(query), ChunkId, boost::uuids::uuid)
PGG_QUERY_ID((ymod_taskmaster)(query), ChunkIds, std::vector<boost::uuids::uuid>)
PGG_QUERY_ID((ymod_taskmaster)(query), Mids, std::vector<std::uint64_t>)
PGG_QUERY_ID((ymod_taskmaster)(query), HostName, std::string)
PGG_QUERY_ID((ymod_taskmaster)(query), LaunchId, std::string)
PGG_QUERY_ID((ymod_taskmaster)(query), Timeout, std::chrono::microseconds)

namespace ymod_taskmaster::query {

using pgg::query::QueryImpl;

struct AddTask : QueryImpl<AddTask, UserId, TaskId, TaskInfo, ChunksInfo> {
    using Inherited::Inherited;
};

struct CanAddTask : QueryImpl<CanAddTask, UserId, Limit> {
    using Inherited::Inherited;
};

struct ChooseChunkIds : QueryImpl<ChooseChunkIds, UserId, Limit> {
    using Inherited::Inherited;
};

struct ChooseUsers : QueryImpl<ChooseUsers, Limit> {
    using Inherited::Inherited;
};

struct GetChunks : QueryImpl<GetChunks, UserId, ChunkIds> {
    using Inherited::Inherited;
};

struct GetChunksByMids : QueryImpl<GetChunksByMids, UserId, Mids> {
    using Inherited::Inherited;
};

struct GetTask : QueryImpl<GetTask, UserId, TaskId> {
    using Inherited::Inherited;
};

struct HasTasks : QueryImpl<HasTasks, UserId> {
    using Inherited::Inherited;
};

struct RemoveChunk : QueryImpl<RemoveChunk, UserId, ChunkId, HostName> {
    using Inherited::Inherited;
};

struct UserStat : QueryImpl<UserStat, UserId> {
    using Inherited::Inherited;
};

struct AcquireLock : QueryImpl<AcquireLock, UserId, Timeout, LaunchId, HostName> {
    using Inherited::Inherited;
};

struct ReleaseLock : QueryImpl<ReleaseLock, UserId, LaunchId> {
    using Inherited::Inherited;
};

using QueriesRegister = pgg::query::RegisterQueries<
    AddTask,
    CanAddTask,
    ChooseChunkIds,
    ChooseUsers,
    GetChunks,
    GetChunksByMids,
    GetTask,
    HasTasks,
    RemoveChunk,
    UserStat,
    AcquireLock,
    ReleaseLock
>;

using ParametersRegister = pgg::query::RegisterParameters<>;

}
