#pragma once

#include <boost/uuid/uuid.hpp>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <mail/mops/ymod_taskmaster/include/ymod_taskmaster/types.hpp>

#include <string>
#include <vector>
#include <inttypes.h>

BOOST_FUSION_DEFINE_STRUCT((ymod_taskmaster)(reflection), Chunk,
    (boost::uuids::uuid, chunk_id)
    (std::string, task_info)
    (std::vector<std::uint64_t>, mids)
)

BOOST_FUSION_DEFINE_STRUCT((ymod_taskmaster)(reflection), BooleanResult,
    (bool, result)
)

BOOST_FUSION_DEFINE_STRUCT((ymod_taskmaster)(reflection), ChooseChunkId,
    (boost::uuids::uuid, chunk_id)
)

BOOST_FUSION_DEFINE_STRUCT((ymod_taskmaster)(reflection), User,
    (std::uint64_t, uid)
)

BOOST_FUSION_DEFINE_STRUCT((ymod_taskmaster)(reflection), TaskStatParams,
    (std::string, o_task_info)
    (std::uint64_t, o_created)
    (size_t, o_count)
)
