#pragma once

#include <multipaxos/types.h>
#include <multipaxos/messages.h>
#include <multipaxos/acceptor_state.h>
#include <multipaxos/callback_logger.h>

namespace multipaxos {

typedef boost::function<void(promise_message& message)> send_promise_callback;
typedef boost::function<void(learn_message& message)> send_learn_callback;
typedef boost::function<void(reject_message& message)> send_reject_callback;
typedef boost::function<void(sync_response_message& message)> send_sync_reponse_callback;

class acceptor_storage_interface;

/**
 * Acceptor
 *
 * incoming commands:
 *  prepare
 *  accept
 *  sync
 *
 * outgoing messages:
 *  promise
 *  learn
 *  reject (accept)
 *  sync response
 *
 */
class acceptor : public callback_logger
{
public:
    acceptor(
        std::shared_ptr<acceptor_storage_interface> storage,
        const acceptor_id_t& acceptor_id,
        log_sev_function_t const& log_func_ = log_sev_function_t());
    ~acceptor();

    acceptor_state state() const;

    void prepare(
        const ballot_t ballot,
        const iid_t slot,
        const iid_t end_slot,
        const send_promise_callback& cb);
    void accept(
        const ballot_t ballot,
        const slot_value_pair& pvalue,
        const send_learn_callback& learn_callback,
        const send_reject_callback& rejectCallback);
    void sync(const std::set<iid_t>& slots, const send_sync_reponse_callback& cb);

private:
    value_triplets get_accepted_values(const std::set<iid_t>& slots);
    value_triplets get_accepted_values(const iid_t slot, const iid_t end_slot);
    void updateBallot(const ballot_t ballot);
    void update_state(const ballot_t ballot, const iid_t slot);
    void update_value(const ballot_t ballot, const slot_value_pair& pvalue);

    acceptor_state state_;

    std::shared_ptr<acceptor_storage_interface> storage_;
    acceptor_id_t acceptor_id_;

    mutable mutex mux_;
};

}
