#pragma once

#include <msgpack.hpp>
#include <multipaxos/types.h>

namespace multipaxos {

struct acceptor_state
{
    ballot_t current_ballot;
    iid_t min_slot;
    iid_t max_slot;

    acceptor_state() : current_ballot(-1), min_slot(-1), max_slot(-1)
    {
    }

    MSGPACK_DEFINE(current_ballot, min_slot, max_slot);
};

}
