#pragma once

#include <multipaxos/acceptor_state.h>
#include <multipaxos/messages.h>
#include <multipaxos/value_triplets.h>
#include <multipaxos/acceptor_state.h>

namespace multipaxos {

typedef ballot_slot_value_triplet acceptor_record;

class acceptor_storage_interface
{
public:
    acceptor_storage_interface()
    {
    }
    virtual ~acceptor_storage_interface()
    {
    }
    virtual int force_syncrony() = 0;
    virtual void update_state(const acceptor_state& state) = 0;
    virtual void update_record(const acceptor_record& record) = 0;
    virtual std::unique_ptr<acceptor_state> lookup_state() = 0;
    virtual std::unique_ptr<acceptor_record> lookup_record(iid_t slot) = 0;
    virtual value_triplets lookup_records(const iid_t fromSlot, const iid_t toSlot) = 0;
};

}
