#pragma once

#include <multipaxos/types.h>
#include <multipaxos/acceptor_storage_interface.h>
#include <multipaxos/callback_logger.h>
#include <boost/scoped_array.hpp>
#include <map>

namespace multipaxos {

class acceptor_storage_memory
    : public acceptor_storage_interface
    , public callback_logger
{
public:
    unsigned MAX_RECORDS = 500000;

    acceptor_storage_memory(unsigned max_records)
        : MAX_RECORDS(max_records), values_(new acceptor_record[MAX_RECORDS])
    {
    }

    virtual int force_syncrony()
    {
        return 0;
    }
    virtual void update_state(const acceptor_state& state)
    {
        state_ = state;
    }
    virtual void update_record(const acceptor_record& record)
    {
        values_[(record.slot % MAX_RECORDS)] = record;
    }
    virtual std::unique_ptr<acceptor_state> lookup_state()
    {
        return std::unique_ptr<acceptor_state>(new acceptor_state(state_));
    }
    virtual std::unique_ptr<acceptor_record> lookup_record(iid_t slot)
    {
        const ballot_slot_value_triplet* value = get(slot);
        return value ? std::unique_ptr<acceptor_record>(new acceptor_record(*value)) :
                       std::unique_ptr<acceptor_record>();
    }
    virtual value_triplets lookup_records(const iid_t fromSlot, const iid_t toSlot)
    {
        value_triplets result;
        for (iid_t i = fromSlot; i <= toSlot; i++)
        {
            const ballot_slot_value_triplet* value = get(i);
            if (value)
            {
                result.add(*value);
            }
        }
        return result;
    }

private:
    const acceptor_record* get(const iid_t slot)
    {
        if (slot < 0)
        {
            return NULL;
        }
        acceptor_record& value = values_[(slot % MAX_RECORDS)];
        return (value.slot == slot) ? &value : NULL;
    }

    acceptor_state state_;
    boost::scoped_array<acceptor_record> values_;
};

}
