#pragma once

#include <multipaxos/types.h>
#include <boost/algorithm/string.hpp>

namespace multipaxos {

struct base_answers_t
{

    base_answers_t() : count(0)
    {
    }

    bool insert(acceptor_id_t const& id)
    {
        bool exist = false;
        for (size_t i = 0; i < count; ++i)
        {
            if (who_answered[i] == id)
            {
                exist = true;
                break;
            }
        }
        if (!exist)
        {
            who_answered[count] = id;
            ++count;
        }
        return !exist;
    }

    size_t get_count() const
    {
        return count;
    }

    void reset()
    {
        for (int i = 0; i < N_OF_ACCEPTORS; ++i)
        {
            who_answered[i] = "";
        }
        count = 0;
    }

    std::string to_string() const
    {
        std::stringstream ss;
        ss << "{" << boost::algorithm::join(who_answered, ",") << "}";
        return ss.str();
    }

private:
    acceptor_id_t who_answered[N_OF_ACCEPTORS];
    size_t count;
};

struct accept_answers_t : public base_answers_t
{
    value_t value;
    ballot_t ballot;

    void reset()
    {
        base_answers_t::reset();
        value.reset();
    }
};

struct promise_answers_t : public base_answers_t
{
    value_triplets values;

    void reset()
    {
        base_answers_t::reset();
        values.clear();
    }
};
}
