#pragma once

#include <multipaxos/paxos_config.h>
#include <multipaxos/types.h>
#include <multipaxos/slots.h>
#include <multipaxos/frame.h>
#include <multipaxos/messages.h>
#include <multipaxos/ntimer.h>
#include <multipaxos/settings.h>
#include <multipaxos/timers_queue.h>
#include <multipaxos/stats.h>
#include <set>

namespace multipaxos {

struct slave_data_t;
struct master_data_t;
class slave_impl;
class master_impl;

class basic_agent
{
public:
    basic_agent(
        const settings_t& settings,
        timers::queue_ptr tq,
        slot_n initial_n,
        slot_n slots_count,
        unsigned node_id);
    ~basic_agent();

    bool stopped() const;
    bool is_master() const;
    const stats_t& get_stats() const;

    void start();
    void stop();

    // public
    // submit a new value
    void submit(value_t value);
    get_status_t get(slot_n num, value_t& value, slot_profile_t& profile);
    void learn_received(learn_message const& msg, acceptor_id_t const& acceptor_id);
    void promise_received(promise_message const& msg, acceptor_id_t const& acceptor_id);
    void reject_received(reject_message const& msg, acceptor_id_t const& acceptor_id);
    void sync_response_received(sync_response_message const& msg, acceptor_id_t const& acceptor_id);
    void master_announce_received(master_announce_message const& msg);
    void set_master();
    void set_not_master();

private:
    void drop_value(value_t value);

private:
    bool master; // node is a master
    bool stopped_;
    shared_ptr<master_data_t> master_data_;
    shared_ptr<slave_data_t> slave_data_;
    shared_ptr<master_impl> master_impl_;
    shared_ptr<slave_impl> slave_impl_;
    frame_t frame_;
    settings_t settings_;
    stats_t stats_;
};

}
