#pragma once

#include <multipaxos/detail/spinlock.h>
#include <mutex>
#include <assert.h>

namespace multipaxos { namespace detail {

/// Promts when we really need to dispatch a queue event.
class event_tracker
{
    spinlock spin;
    unsigned count = 0;
    bool active = false;

public:
    unsigned get_count()
    {
        std::lock_guard<spinlock> guard(spin);
        return count;
    }

    // returns true if need event dispatching
    bool produce(const unsigned amount)
    {
        bool need_action = false;
        std::lock_guard<spinlock> guard(spin);
        count += amount;
        if (count && !active)
        {
            active = true;
            need_action = true;
        }
        return need_action;
    }

    // returns true if need event dispatching
    bool consume(const unsigned amount)
    {
        assert(active);
        bool need_action = false;
        std::lock_guard<spinlock> guard(spin);
        count -= amount;
        if (count)
        {
            need_action = true;
        }
        else
        {
            active = false;
        }
        return need_action;
    }
};

} // namespace detail
} // namespace multipaxos