#pragma once

#include <string>
#include <vector>
#include <inttypes.h>
#include <string.h>
#include <boost/shared_ptr.hpp>

#include <msgpack.hpp>

#include <multipaxos/types.h>
#include <multipaxos/value_triplets.h>

namespace multipaxos {

struct prepare_message
{
    ballot_t ballot;
    iid_t slot;
    iid_t end_slot;

    MSGPACK_DEFINE(ballot, slot, end_slot);
};

struct promise_message
{
    ballot_t requested_ballot;
    iid_t requested_slot;
    ballot_t acceptor_ballot;
    value_triplets accepted_values;
    acceptor_id_t acceptor_id;
    iid_t max_slot;
    MSGPACK_DEFINE(
        requested_ballot,
        requested_slot,
        acceptor_ballot,
        accepted_values,
        acceptor_id,
        max_slot);
};

struct accept_message
{
    ballot_t ballot;
    slot_value_pair pvalue;

    MSGPACK_DEFINE(ballot, pvalue);
};

struct learn_message
{
    ballot_t ballot;
    slot_value_pair accepted_value;
    acceptor_id_t acceptor_id;
    MSGPACK_DEFINE(ballot, accepted_value, acceptor_id);
};

struct reject_message
{
    ballot_t request_ballot;
    iid_t request_slot;
    ballot_t acceptor_ballot;
    acceptor_id_t acceptor_id;
    MSGPACK_DEFINE(request_ballot, request_slot, acceptor_ballot, acceptor_id);
};

struct sync_request_message
{
    std::set<iid_t> slots;
    MSGPACK_DEFINE(slots);
};

struct sync_response_message
{
    value_triplets pvalues;
    iid_t max_slot;
    acceptor_id_t acceptor_id;
    MSGPACK_DEFINE(pvalues, acceptor_id);
};

struct master_announce_message
{
    iid_t read;
    iid_t write;
    MSGPACK_DEFINE(read, write);
};

typedef boost::function<void(accept_message& msg)> send_accept_message_t;
typedef boost::function<void(prepare_message& msg)> send_prepare_message_t;
typedef boost::function<void(sync_request_message& msg)> send_sync_message_t;
typedef boost::function<void(master_announce_message& msg)> send_announce_message_t;

typedef boost::function<void(ballot_t ballot, const slot_value_pair& pvalue)> learn_callback;

}
