#pragma once

#include <boost/lockfree/spsc_queue.hpp>
#include <mutex>

namespace multipaxos {

/// Multiple producers and single consumer wrapper for spsc_queue.
template <typename T>
class mp_sc_queue
{
    typedef boost::lockfree::spsc_queue<T> impl_type;
    impl_type impl;
    detail::spinlock producers_spin;

public:
    mp_sc_queue(const typename impl_type::size_type size) : impl(size)
    {
    }

    bool push(const T& t)
    {
        // guard pushes from producers
        std::lock_guard<detail::spinlock> guard(producers_spin);
        return impl.push(t);
    }

    bool pop(T& t)
    {
        // don't guard pops from consumer
        return impl.pop(&t, 1);
    }
};

} // namespace multipaxos
