#pragma once

#include <multipaxos/types.h>
#include <string>
#include <iomanip>

namespace multipaxos {

class ntimer_t
{
public:
    typedef uint64_t milliseconds_t;

    ntimer_t()
    {
        reset();
    }

    void reset()
    {
        initiated = clock::now();
    }

    milliseconds_t shot() const
    {
        return duration_cast<milliseconds>(clock::now() - initiated).count();
    }

protected:
    time_point initiated;
};

inline std::string to_string(const ntimer_t& prof_timer)
{
    std::stringstream ss;
    ss << std::fixed << std::setprecision(3) << static_cast<double>(prof_timer.shot()) * 0.001;
    return ss.str();
}

}
