#pragma once

#include <multipaxos/types.h>
#include <multipaxos/paxos_config.h>
#include <multipaxos/messages.h>

namespace multipaxos {

struct algorithm_settings_t
{
    time_duration prepare_max_time;
    time_duration propose_max_time;
    time_duration announce_interval;
    time_duration sync_interval;

    unsigned max_parallel_accepts;
    unsigned max_prepare_step;
    unsigned lag_to_report;
    bool drop_submits_while_preparing;
    unsigned sync_max_size;

    algorithm_settings_t()
        : prepare_max_time(milliseconds(3000))
        , propose_max_time(milliseconds(1000))
        , announce_interval(milliseconds(2000))
        , sync_interval(milliseconds(2000))
        , max_parallel_accepts(100)
        , max_prepare_step(2000)
        , lag_to_report(300000)
        , drop_submits_while_preparing(false)
        , sync_max_size(256)
    {
    }
};

struct dependencies_t
{
    deliver_function_t deliver_func;
    drop_function_t drop_func;
    log_function_t log_func;
    log_function_t debug_log_func;
    report_function_t report_func;

    send_accept_message_t send_accept_message;
    send_prepare_message_t send_prepare_message;
    send_announce_message_t send_announce_message;
    send_sync_message_t send_sync_message;
};

struct settings_t
    : public algorithm_settings_t
    , public dependencies_t
{
};

}