/**
 * @file:   types.h
 * @author: nordsturm
 * © Yandex LLC.
 */

#pragma once

#include <string>
#include <list>
#include <vector>

#include <boost/shared_ptr.hpp>
#include <boost/function.hpp>

#include <boost/shared_ptr.hpp>
#include <boost/function.hpp>
#include <boost/bind.hpp>
#include <boost/uuid/uuid_io.hpp>
#include <boost/accumulators/accumulators.hpp>
#include <boost/accumulators/statistics.hpp>

#include <msgpack.hpp>

#include <multipaxos/buffer.h>
#include <chrono>

namespace multipaxos {

///@todo make struct
typedef int64_t iid_t;

typedef buffer_t value_t;
// XXX init with defaults
// XXX make a special state defalut values (for externally proposed values)
struct slot_profile_t
{
    uint64_t commit_time;
    uint64_t total_time;
};

enum report_code
{
    dummy,
    lagging,
    prepare_timeout,
    accept_timeout,
};

typedef boost::function<void(iid_t)> deliver_function_t;
typedef boost::function<void(iid_t, value_t, slot_profile_t const&)> deliver_value_function_t;
typedef boost::function<void(value_t)> drop_function_t;
typedef boost::function<void(std::string const&)> log_function_t;
typedef boost::function<void(report_code)> report_function_t;

using std::string;

using std::unique_ptr;
using std::unique_ptr;
using boost::shared_ptr;

using std::mutex;
using scoped_lock = std::unique_lock<mutex>;

using clock = std::chrono::steady_clock;
using time_point = clock::time_point;
using time_duration = clock::duration;
using std::chrono::milliseconds;
using std::chrono::duration_cast;

// typedef ymod_netch::netch_mcast netch;
// typedef ymod_netch::user_id_t netch_node_id;
// typedef ymod_netch::mcast_addr_t netch_mcast_addr;
// typedef ymod_netch::message_type_t netch_message_type;

///@todo make struct with msgpack macro
// BOOST_STRONG_TYPEDEF(int32_t, ballot_t)
typedef int64_t ballot_t;

typedef string acceptor_id_t;

typedef iid_t slot_n;
// typedef unsigned acceptor_id_t;

enum class cb_severity_level : int
{
    error = 0,
    info,
    debug
};
typedef boost::function<void(cb_severity_level severity, std::string const&)> log_sev_function_t;

enum class get_status_t
{
    ok,
    not_ready,
    too_old,
};

struct severity_stream_logger : public boost::noncopyable
{
    severity_stream_logger(log_sev_function_t const& f, cb_severity_level severity_)
        : func(f), severity(severity_)
    {
    }
    ~severity_stream_logger()
    {
        func(severity, ss.str());
    }
    template <typename T>
    severity_stream_logger& operator<<(T const& t)
    {
        ss << t;
        return *this;
    }

private:
    log_sev_function_t const& func;
    cb_severity_level severity;
    std::stringstream ss;
};

#define L_SEV_STREAM(log_func, severity, output)                                                   \
    if (log_func) severity_stream_logger(log_func, cb_severity_level::severity) << output;

#define ACCEPTOR_LOG(severity, output) L_SEV_STREAM(log_func, severity, output)
#define STORAGE_LOG(severity, output) L_SEV_STREAM(log_func, severity, "[paxos:DB] " << output)

}
