#pragma once

#include <msgpack.hpp>
#include <multipaxos/types.h>

namespace multipaxos {

struct slot_value_pair
{
    iid_t slot;
    value_t value;

    MSGPACK_DEFINE(slot, value);
};

inline bool operator<(const slot_value_pair& t1, const slot_value_pair& t2)
{
    return t1.slot < t2.slot;
}

struct ballot_slot_value_triplet
{
    ballot_t ballot;
    iid_t slot;
    value_t value;

    ballot_slot_value_triplet() : ballot(-1), slot(-1)
    {
    }
    ballot_slot_value_triplet(ballot_t _ballot, iid_t _slot, value_t _value)
        : ballot(_ballot), slot(_slot), value(_value)
    {
    }

    slot_value_pair make_slot_value_pair()
    {
        slot_value_pair result = { slot, value };
        return result;
    }

    MSGPACK_DEFINE(ballot, slot, value);
};

inline bool operator<(const ballot_slot_value_triplet& t1, const ballot_slot_value_triplet& t2)
{
    return t1.slot < t2.slot;
}

class value_triplets
{
public:
    typedef std::vector<ballot_slot_value_triplet> items_type;

    void add(const ballot_slot_value_triplet& triplet);

    void merge(const value_triplets& from);

    const items_type& items() const;

    void clear();

    MSGPACK_DEFINE(items_);

private:
    items_type items_;
};

class value_pairs
{
public:
    typedef std::deque<slot_value_pair> items_type;

    bool slot_is_free(iid_t slot);

    const slot_value_pair& get(iid_t slot);

    value_t pop_value(iid_t slot);

    void put(const slot_value_pair& pvalue);

    void remove(iid_t slot);

    bool has_value(value_t value);

    bool remove_value(value_t value);

    const items_type& items() const;

    void clear();

    MSGPACK_DEFINE(items_);

private:
    items_type items_;
};

}
