#pragma once

#include <multipaxos/types.h>
#include <multipaxos/frame.h>

#include "logger.h"

#define DL log_func
#define L_STREAM                                                                                   \
    if (log_func) logger_t(log_func)
#define FRAME_TO_STREAM_COMMON                                                                     \
    " read=" << frame.read_zone_begin() << " write=" << frame.write_zone_begin()

namespace multipaxos {

namespace {
inline bool is_committed(frame_t& frame, slot_n n)
{
    slot_t& slot = frame.get_slot(n);
    return slot.is_inited_as(n) && slot.get_state() == state_t::committed;
}
inline bool is_committed(slot_t& slot, slot_n n)
{
    return slot.is_inited_as(n) && slot.get_state() == state_t::committed;
}
}

inline get_status_t get(
    frame_t& frame,
    const log_function_t& log_func,
    slot_n num,
    value_t& value,
    slot_profile_t& profile)
{
    if (num >= frame.write_zone_end())
    {
        if (DL) L_STREAM << "GET after the end slot=" << num << FRAME_TO_STREAM_COMMON;
        return get_status_t::not_ready;
    }

    if (num < frame.read_zone_begin())
    {
        return get_status_t::too_old;
    }

    if (num >= frame.read_zone_end())
    {
        return get_status_t::not_ready;
    }

    slot_t& slot = frame.get_slot(num);
    assert(slot.committed_as(num));
    profile.total_time = slot.profile_timer.shot();
    profile.commit_time = slot.commit_time;
    value = std::move(slot.value);
    L_STREAM << "j_delivered num=" << num << FRAME_TO_STREAM_COMMON;
    slot.reset();
    frame.cut_read_zone(num + 1);
    return get_status_t::ok;
}

}

#undef L_STREAM
#undef DL
