#pragma once

#include <multipaxos/slots.h>

namespace multipaxos {

struct logger_t : public boost::noncopyable
{

    logger_t(const log_function_t& f) : func(f)
    {
    }

    ~logger_t()
    {
        func(ss.str());
    }

    template <typename T>
    logger_t& operator<<(T const& t)
    {
        ss << t;
        return *this;
    }

private:
    const log_function_t& func;
    std::stringstream ss;
};

}
