/**
 * @file:   time_millis.h
 * @author: nordsturm
 * © Yandex LLC.
 */

#ifndef TIME_MILLIS_H
#define TIME_MILLIS_H

#include <sys/time.h>

typedef long unsigned TimeMillis;

inline TimeMillis get_time_millis()
{
    // Time in milliseconds since 1 Jan 2008
    // More or less...
    struct timeval tv;
    struct timezone tz;
    gettimeofday(&tv, &tz);
    return ((tv.tv_sec - 1198368000) * 1000) + (tv.tv_usec / 1000);
}

#endif
