#include <multipaxos/value_triplets.h>

using namespace multipaxos;

namespace {
struct pair_finder
{
    iid_t slot;

    pair_finder(iid_t _slot) : slot(_slot)
    {
    }
    bool operator()(const slot_value_pair& pair)
    {
        return pair.slot == slot;
    }
};
struct insert_pair_finder
{
    iid_t slot;

    insert_pair_finder(iid_t _slot) : slot(_slot)
    {
    }
    bool operator()(const slot_value_pair& pair)
    {
        return pair.slot >= slot;
    }
};
}

void value_triplets::add(const ballot_slot_value_triplet& triplet)
{
    items_type::iterator it = std::lower_bound(items_.begin(), items_.end(), triplet);
    if (it != items_.end() && it->slot == triplet.slot)
    {
        *it = triplet;
    }
    else
    {
        items_.insert(it, triplet);
    }
}

void value_triplets::merge(const value_triplets& from)
{
    std::ostringstream ostr;
    ostr << "merging slots ( ";
    for (size_t i = 0; i < items_.size(); i++)
    {
        ostr << items_[i].slot << ",b" << items_[i].ballot << " ";
    }
    ostr << ")\n";
    ostr << "         with ( ";
    for (size_t i = 0; i < from.items_.size(); i++)
    {
        ostr << from.items_[i].slot << ",b" << from.items_[i].ballot << " ";
    }
    ostr << ")\n";

    items_type::iterator it = items_.begin();
    // for each value
    for (size_t i = 0; i < from.items_.size(); i++)
    {
        // find it in our values
        for (; it != items_.end(); ++it)
        {
            if (it->slot >= from.items_[i].slot)
            {
                break;
            }
        }

        if (it == items_.end())
        {
            it = items_.insert(it, from.items_[i]);
        }
        else
        {
            if (it->slot == from.items_[i].slot)
            {
                if (it->ballot < from.items_[i].ballot)
                {
                    *it = from.items_[i];
                }
            }
            else
            {
                it = items_.insert(it, from.items_[i]);
            }
        }
    }

    ostr << "    result is ( ";
    for (size_t i = 0; i < items_.size(); i++)
    {
        ostr << items_[i].slot << ",b" << items_[i].ballot << " ";
    }
    ostr << ")";
    // LEADER_LOG(debug) << "*** value_triplets::merge\n" << ostr.str();
    //    std::cout << "*** value_triplets::merge\n" << ostr.str() << "\n";
}

const value_triplets::items_type& value_triplets::items() const
{
    return items_;
}

void value_triplets::clear()
{
    items_.clear();
}

bool value_pairs::slot_is_free(iid_t slot)
{
    items_type::const_iterator found =
        std::find_if(items_.begin(), items_.end(), pair_finder(slot));
    if (found == items_.end())
    {
        return true;
    }
    else
    {
        return false;
    }
}

const slot_value_pair& value_pairs::get(iid_t slot)
{
    items_type::const_iterator found =
        std::find_if(items_.begin(), items_.end(), pair_finder(slot));
    if (found == items_.end())
    {
        throw std::runtime_error("value_pairs::get() no such slot");
    }
    else
    {
        return *found;
    }
}

value_t value_pairs::pop_value(iid_t slot)
{
    value_t result;
    items_type::iterator it = std::find_if(items_.begin(), items_.end(), pair_finder(slot));
    if (it != items_.end())
    {
        result = it->value;
        items_.erase(it);
    }
    return result;
}

void value_pairs::put(const slot_value_pair& pvalue)
{
    items_type::iterator it = std::lower_bound(items_.begin(), items_.end(), pvalue);
    if (it != items_.end() && it->slot == pvalue.slot)
    {
        *it = pvalue;
    }
    else
    {
        items_.insert(it, pvalue);
    }
}

void value_pairs::remove(const iid_t slot)
{
    items_type::iterator it = std::find_if(items_.begin(), items_.end(), pair_finder(slot));
    if (it != items_.end())
    {
        items_.erase(it);
    }
}

bool value_pairs::has_value(value_t value)
{
    for (const items_type::value_type& pvalue : items_)
    {
        if (buffer_equals(pvalue.value, value))
        {
            return true;
        }
    }
    return false;
}

bool value_pairs::remove_value(value_t value)
{
    items_type::iterator it = items_.begin();
    for (; it != items_.end(); ++it)
    {
        if (buffer_equals(it->value, value))
        {
            items_.erase(it);
            return true;
        }
    }
    return false;
}

const value_pairs::items_type& value_pairs::items() const
{
    return items_;
}

void value_pairs::clear()
{
    return items_.clear();
}
