# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import re


def _get_dkim_domain(d):
    s = re.search(r"header.d\s*=\s*([^\s]+)", d)
    if not s or not s.groups():
        s = re.search(r"header.i\s*=\s*[^\s]*@([^\s]+)", d)
    if not s or not s.groups():
        return None
    return s.groups()[0]


def _get_dkim_stat(d):
    s = re.search(r"dkim\s*=\s*([a-z]+)", d)
    if not s or not s.groups():
        return None
    return s.groups()[0]


def parse_authentication_results(s):
    for c in s.split(";"):
        status = _get_dkim_stat(c)
        if status is not None:
            return {
                "status": status,
                "domain": _get_dkim_domain(c)
            }
    return None
