# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from urllib import urlencode
from urlparse import urljoin

import json
import requests

from lib import ssh
from lib.cache import memoize
from lib.settings import SETTINGS

BIGML_URL = SETTINGS["bigml"]["url"]
USE_SSH_PROXY = SETTINGS["bigml"]["use_ssh_proxy"]

_cache = {}


@memoize(_cache)
def get_subscribers(email_from, email_to):
    if USE_SSH_PROXY:
        return _get_emails(_get_subscribers_through_proxy(email_from, email_to))
    return _get_emails(_get_subscribers(email_from, email_to))


def _build_recipients_url(email_from, email_to):
    query_args = {
        "email_from": email_from,
        "email_to": email_to
    }
    endpoint = "/api/v1/recipients?{query_string}"
    return urljoin(BIGML_URL, endpoint.format(query_string=urlencode(query_args)))


def _get_subscribers(email_from, email_to):
    url = _build_recipients_url(email_from, email_to)
    response = requests.get(url, verify=False)
    return response.json()


def _get_subscribers_through_proxy(email_from, email_to):
    url = _build_recipients_url(email_from, email_to)
    cmd = "curl -s '{url}' --insecure".format(url=url)
    ssh_client = ssh.get_sshclient()
    stdout, _ = ssh.exec_command(ssh_client, cmd)
    return json.loads(stdout.read())


def _get_emails(json_body):
    if json_body["status"] != "ok":
        raise RuntimeError("BigML error: {}".format(json_body["response"]["message"]))
    return [item["email"] for item in json_body["response"]["subscriptions"]]
