# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import backoff

from contextlib import contextmanager
from exchangelib import Account, Configuration, Credentials

from lib.settings import SETTINGS

EXCHANGE_SERVER = SETTINGS["exchange"]["host"]

INBOX = "INBOX"
NUMBER_OF_MESSAGES = 10


@contextmanager
@backoff.on_exception(
    backoff.constant,
    Exception,
    max_tries=5,
    interval=1
)
def create_exchange_session(exchange_server, user):
    credentials = Credentials(username=user.login, password=user.pwd)
    config = Configuration(server=exchange_server, credentials=credentials)
    account = Account(user.email, credentials=credentials, autodiscover=False, config=config)

    if account is None:
        raise RuntimeError("Can't create exchange session")

    yield account


def find_messages_by_msg_id(user, msg_id, exchange_server=EXCHANGE_SERVER):
    with create_exchange_session(exchange_server=exchange_server, user=user) as session:
        return [message for message in session.inbox.all().order_by('-datetime_received')[:NUMBER_OF_MESSAGES] if message.message_id == msg_id]
