# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import email
import socket
from contextlib import contextmanager
from imaplib import IMAP4_SSL, IMAP4

from lib.headers import Header
from lib.settings import SETTINGS

INBOX = "INBOX"
# "Нежелательные сообщения" в кодировке utf7-imap для ld.yandex.ru
EXCHANGE_SPAM_FOLDER = '"&BB0ENQQ2BDUEOwQwBEIENQQ7BEwEPQQwBE8- &BD8EPgRHBEIEMA-"'


@contextmanager
def create_imap_session(imap_server, login, pwd):
    is_imap_session_exist = False
    retry_number = 0
    session = None
    # [MAILDLV-2740] Добавляем ретраи на залогин и установку имап соединения. Нужно для внешних почт.
    while not is_imap_session_exist and retry_number < 5:
        try:
            session = IMAP4_SSL(imap_server)
            session.login(login, pwd)
            is_imap_session_exist = True
        except (IMAP4.abort, socket.error):
            retry_number = retry_number + 1
            is_imap_session_exist = False
    if not is_imap_session_exist:
        raise RuntimeError("Can't create imap session")
    try:
        yield session
    finally:
        session.close()
        session.logout()


def find_messages_by_header(imap_server, user, header_name, header_value, folder=INBOX):
    if imap_server is None:
        imap_server = SETTINGS["external_imap"][user.domain.replace('.', '_')]["host"]

    with create_imap_session(imap_server=imap_server, login=user.login, pwd=user.pwd) as session:
        session.select(folder)

        typ, data = session.search(None, "(HEADER {header_name} \"{header_value}\")"
                                   .format(header_name=header_name, header_value=header_value))
        found_messages = []
        for num in data[0].split():
            typ, data = session.fetch(num, "(RFC822)")
            message = email.message_from_string(data[0][1])
            found_messages.append(message)

        return found_messages


def find_messages_by_msg_id(imap_server, user, msg_id, folder=INBOX):
    return find_messages_by_header(imap_server, user, Header.MESSAGE_ID, msg_id, folder)


def find_message_by_msg_id(imap_server, user, msg_id, folder=INBOX):
    return find_messages_by_msg_id(imap_server, user, msg_id, folder)[0]
