# -*- coding: utf-8 -*-

import logging

TEST_CASE_NAME = "NA"


class TestCaseAwareLogger(logging.Logger):
    def makeRecord(self, name, level, fn, lno, msg, args, exc_info, func=None, extra=None):
        if extra is None:
            extra = {}
        extra.update({'test_name': TEST_CASE_NAME})
        return super(TestCaseAwareLogger, self).makeRecord(
            name, level, fn, lno, msg, args, exc_info, func, extra=extra)


def _suppress_requests_warning():
    import urllib3
    urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

    import warnings
    warnings.filterwarnings(action="ignore", module=".*paramiko.*")

    import requests.packages.urllib3 as requests_urllib3
    requests_urllib3.disable_warnings(requests_urllib3.exceptions.InsecureRequestWarning)


def setup_logging(filename='test.log'):
    fmt = '[%(asctime)-15s][%(process)d][%(test_name)s][%(name)s]: %(message)s'
    logging.setLoggerClass(TestCaseAwareLogger)
    logging.basicConfig(filename=filename, level=logging.DEBUG, format=fmt)
    _suppress_requests_warning()


def set_test_case_name(test_name):
    global TEST_CASE_NAME
    TEST_CASE_NAME = test_name


def reset_test_case_name():
    set_test_case_name("NA")
