# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from hamcrest.core.base_matcher import BaseMatcher


class BaseModifyMatcher(BaseMatcher):
    def __init__(self, matcher):
        self.matcher = matcher

    def _matches(self, item):
        self.new_item = self.modify(item)
        return self.matcher.matches(self.new_item)

    def describe_mismatch(self, item, description):
        description.append_text("is expected, actual ")
        self.matcher.describe_mismatch(self.new_item, description)

    def describe_to(self, description):
        description.append_text(self.description + " ")
        description.append_description_of(self.matcher)
