# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from hamcrest.core.base_matcher import BaseMatcher

from lib.exchange import find_messages_by_msg_id
from lib.matchers.wait_matcher import wait_for


class ExchangeBasedDeliveryMatcher(BaseMatcher):
    def __init__(self, msg_id, expected_count):
        self.msg_id = msg_id
        self.expected_count = expected_count
        self.actual_count = 0

    def _matches(self, user):
        messages = find_messages_by_msg_id(user, self.msg_id)
        self.actual_count = len(messages)
        return self.actual_count == self.expected_count

    def describe_mismatch(self, user, description):
        msg = (
            "В ящике пользователя {email} по протоколу imap найдены письма"
            " с Message-Id={msg_id}"
            " в количестве {actual_count}"
            " в папке {folder}")
        msg = msg.format(
            email=user.email, msg_id=self.msg_id,
            actual_count=self.actual_count,
            folder=self.folder)
        description.append_text(msg)

    def describe_to(self, description):
        msg = (
            "Письмо с Message-Id={msg_id}"
            " должно быть доставлено в количестве {expected_count}"
            " в папку {folder}!")
        msg = msg.format(
            msg_id=self.msg_id,
            expected_count=self.expected_count,
            folder=self.folder)
        description.append_text(msg)


def has_delivered_message(msg_id, expected_count=1):
    return wait_for(ExchangeBasedDeliveryMatcher(msg_id, expected_count))
