# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from hamcrest.core.base_matcher import BaseMatcher

from lib.imap import find_messages_by_msg_id, INBOX
from lib.matchers.wait_matcher import wait_for


class IMAPBasedDeliveryMatcher(BaseMatcher):
    def __init__(self, imap_server, msg_id, folder, expected_count):
        self.imap_server = imap_server
        self.msg_id = msg_id
        self.folder = folder
        self.expected_count = expected_count
        self.actual_count = 0

    def _matches(self, user):
        messages = find_messages_by_msg_id(self.imap_server, user, self.msg_id, self.folder)
        self.actual_count = len(messages)
        return self.actual_count == self.expected_count

    def describe_mismatch(self, user, description):
        msg = (
            "В ящике пользователя {email} по протоколу imap найдены письма"
            " с Message-Id={msg_id}"
            " в количестве {actual_count}"
            " в папке {folder}")
        msg = msg.format(
            email=user.email, msg_id=self.msg_id,
            actual_count=self.actual_count,
            folder=self.folder)
        description.append_text(msg)

    def describe_to(self, description):
        msg = (
            "Письмо с Message-Id={msg_id}"
            " должно быть доставлено в количестве {expected_count}"
            " в папку {folder}!")
        msg = msg.format(
            msg_id=self.msg_id,
            expected_count=self.expected_count,
            folder=self.folder)
        description.append_text(msg)


def has_delivered_messages_to_imap_mailbox_with_msgid(imap_server, msg_id, folder, expected_count):
    return wait_for(IMAPBasedDeliveryMatcher(imap_server, msg_id, folder, expected_count))


def has_delivered_message_to_imap_mailbox_with_msgid(imap_server, msg_id, folder=INBOX):
    return has_delivered_messages_to_imap_mailbox_with_msgid(imap_server, msg_id, folder, 1)
