# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import difflib

from hamcrest import equal_to
from hamcrest.core.base_matcher import BaseMatcher

from lib.headers import Header
from lib.received_header_parser import get_hop_info


class DeliveryRouteMatcher(BaseMatcher):
    def __init__(self, expected_route):
        self.expected_route = expected_route
        self.route = []

    def _matches(self, message):
        self.route = build_delivery_route(message)
        return equal_to(self.expected_route).matches(self.route)

    def describe_mismatch(self, message, description):
        diff = difflib.ndiff(self.expected_route, self.route)
        description.append_text(" => ".join(self.route))
        description.append_text("\nDiff:\n")
        description.append_text("\n".join(diff))

    def describe_to(self, description):
        description.append_text(" => ".join(self.expected_route))


def build_delivery_route(message):
    received_headers = message.get_all(Header.RECEIVED)
    # reverse order of headers in order to stand it in direct order;
    # sort by date is useless, because received headers often have the same date
    received_headers.reverse()
    return map(get_hop_info, received_headers)


def has_delivery_route(delivery_route_regexp):
    return DeliveryRouteMatcher(delivery_route_regexp)
