# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from hamcrest import contains_inanyorder

from lib.matchers.base import BaseModifyMatcher
from lib.psql import find_folder_by_path


def has_fids(fids):
    class FidsMatcher(BaseModifyMatcher):
        description = "box rows fids"
        modify = lambda _, box_rows: [row.fid for row in box_rows if row]

    return FidsMatcher(contains_inanyorder(*fids))


def has_folders(user, folders):
    expected_fids = [find_folder_by_path(user.uid, folder).fid for folder in folders]
    return has_fids(expected_fids)
