# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import difflib

from hamcrest.core.base_matcher import BaseMatcher


class MessageCompareMatcher(BaseMatcher):
    def __init__(self, expected_message, headers_excluded_from_comparison):
        self.expected_message = expected_message
        self.headers_excluded_from_comparison = headers_excluded_from_comparison

    def _matches(self, message):
        remove_headers_from_msg(self.headers_excluded_from_comparison, message)
        return message.as_string().strip() == self.expected_message.as_string().strip()

    def describe_mismatch(self, message, description):
        for line in difflib.unified_diff(self.expected_message.as_string().strip().splitlines(),
                                         message.as_string().strip().splitlines()):
            description.append_text(line + "\n")

    def describe_to(self, description):
        description.append_text(
            "Сообщения одинаковые, за исключением заголовков " + str(self.headers_excluded_from_comparison)
        )


def remove_headers_from_msg(headers_to_remove, all_headers):
    for key in headers_to_remove:
        if key in all_headers:
            del all_headers[key]


def is_equal_to_the_message(expected_message, headers_excluded_from_comparison):
    return MessageCompareMatcher(expected_message, headers_excluded_from_comparison)
