# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import time

from hamcrest.core.base_matcher import BaseMatcher
from hamcrest.core.helpers.wrap_matcher import wrap_matcher

DEFAULT_INTERVAL = 1
DEFAULT_TIMEOUT = 60  # sec


class WaitMatcher(BaseMatcher):
    def __init__(self, matcher, timeout, interval):
        self.matcher = matcher
        self.timeout = timeout
        self.interval = interval

    def _matches(self, item):
        start = time.time()
        end = start + self.timeout
        while time.time() < end:
            if self.matcher.matches(item):
                return True
            time.sleep(self.interval)
        return self.matcher.matches(item)

    def describe_mismatch(self, item, description):
        self.matcher.describe_mismatch(item, description)

    def describe_to(self, description):
        description.append_text("После ожидания [{timeout}] секунд ".format(timeout=self.timeout))
        description.append_description_of(self.matcher)


def wait_for(matcher):
    return WaitMatcher(wrap_matcher(matcher), DEFAULT_TIMEOUT, DEFAULT_INTERVAL)
