# -*- coding: utf-8 -*-

import email
from email.message import Message
from email.mime.message import MIMEMessage
from email.mime.text import MIMEText

from lib.headers import Header
# https://ru.wikipedia.org/wiki/EICAR-Test-File
from lib.random_generator import get_random_string

VIRUS_TEXT = "X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*"
# https://ru.wikipedia.org/wiki/GTUBE
STRONG_SPAM_TEXT = "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STRONG-ANTI-UBE-TEST-EMAIL*C.34X"
STANDARD_SPAM_TEXT = "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL*C.34X"
PERSONAL_SPAM_TEXT = "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-PERSONAL-ANTI-UBE-TEST-EMAIL*C.34X"
IMPORTANT_TEXT = "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-IMPORTANT-ANTI-UBE-TEST-EMAIL*C.34X"
URL_RBL = "XJS*C4JDBQADN1.NSBN3*2IDNEN*RES_URL_RBL_OUT-TEST-EMAIL*C.34X"
RFC_FAIL = "XJS*C4JDBQADN1.NSBN3*2IDNEN*RES_RFC_FAIL_OUT-TEST-EMAIL*C.34X"
BAD_KARMA = "XJS*C4JDBQADN1.NSBN3*2IDNEN*RES_BAD_KARMA-TEST-EMAIL*C.34X"
MAIL_LIMITS = "XJS*C4JDBQADN1.NSBN3*2IDNEN*RES_LIMITS-TEST-EMAIL*C.34X"
PDD_ADMIN_KARMA = "XJS*C4JDBQADN1.NSBN3*2IDNEN*RES_PDD_ADMKARMA-TEST-EMAIL*C.34X"
SPAM_COMPL = "XJS*C4JDBQADN1.NSBN3*2IDNEN*RES_COMPLS-TEST-EMAIL*C.34X"
BOUNCES = "XJS*C4JDBQADN1.NSBN3*2IDNEN*RES_BOUNCES-TEST-EMAIL*C.34X"


def _fill_message_headers(msg, from_email, to_emails, headers):
    if not isinstance(to_emails, (tuple, list)):
        to_emails = (to_emails,)

    if from_email is not None:  # will add nobody otherwise
        del msg[Header.FROM]
        msg[Header.FROM] = from_email
    for rcpt in to_emails:
        msg[Header.TO] = rcpt
    for name, value in headers.iteritems():
        del msg[name]
        msg[name] = value
    return msg


def build_plain_text_message(from_email, to_emails, text, headers, charset="utf-8"):
    if isinstance(text, str):
        text = text.decode(charset)
    msg = MIMEText(text.encode(charset), "plain", charset)
    return _fill_message_headers(msg, from_email, to_emails, headers)


def build_message_from_file(file_obj, to_emails, headers):
    msg = email.message_from_file(file_obj)
    from_email = msg[Header.FROM]
    del msg[Header.FROM]
    del msg[Header.TO]
    return _fill_message_headers(msg, from_email, to_emails, headers)


def build_message_from_file_without_reset_to(file_obj, headers):
    msg = email.message_from_file(file_obj)
    return _fill_message_headers(msg, None, [], headers)


def build_virus_message(from_email, to_emails, headers):
    return build_plain_text_message(from_email, to_emails, VIRUS_TEXT, headers)


def build_strongspam_message(from_email, to_emails, headers):
    if headers is None:
        headers = {}
    # SO caches resolution
    # TODO(SODEV-1457) use msg_id instead of subject for cache misses after the ticket
    if Header.SUBJECT not in headers:
        headers[Header.SUBJECT] = get_random_string(5)
    return build_plain_text_message(from_email, to_emails, STRONG_SPAM_TEXT, headers)


def build_spam_message(from_email, to_emails, headers):
    if headers is None:
        headers = {}
    # SO caches resolution
    # TODO(SODEV-1457) use msg_id instead of subject for cache misses after the ticket
    if Header.SUBJECT not in headers:
        headers[Header.SUBJECT] = get_random_string(5)
    return build_plain_text_message(from_email, to_emails, STANDARD_SPAM_TEXT, headers)


def build_personal_spam_message(from_email, to_emails, headers):
    if headers is None:
        headers = {}
    # SO caches resolution
    # TODO(SODEV-1457) use msg_id instead of subject for cache misses after the ticket
    if Header.SUBJECT not in headers:
        headers[Header.SUBJECT] = get_random_string(5)
    return build_plain_text_message(from_email, to_emails, PERSONAL_SPAM_TEXT, headers)


def build_important_message(from_email, to_emails, headers):
    # https://st.yandex-team.ru/SODEV-2149
    return build_plain_text_message(from_email, to_emails, IMPORTANT_TEXT, headers)


def build_mime_message(text, **headers):
    if "Subject" not in headers:
        headers["Subject"] = "Hello"

    msg = Message()
    msg.set_payload(text)
    _fill_message_headers(msg, None, [], headers)
    return MIMEMessage(msg)
