# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
from urllib import urlencode
from urlparse import urljoin

import requests
from lib.fids import INBOX_FID
from lib.random_generator import get_random_number, get_random_string
from lib.settings import get_mx_settings
from lib.utils import build_multipart

MX_HOST = get_mx_settings()["host"]


def _build_base_url(host=MX_HOST):
    return "http://{host}:8027".format(host=host)


def _get_request_id():
    return get_random_string(10)


class HTTPClient(object):
    def __init__(self):
        self._base_url = _build_base_url()

    def _get_store_url(self, query_args):
        return urljoin(self._base_url, "/mail/store?" + urlencode(query_args))

    def store(self, json_body, rfc822_body, uid, fid=None, service="sendbernar", request_id=_get_request_id()):
        params = {"uid": uid, "fid": fid, "service": service, "request_id": request_id}
        if fid is None:
            params.pop('fid')
        url = self._get_store_url(params)
        boundary, multipart = build_multipart(json.dumps(json_body), rfc822_body)
        headers = {
            "Content-Type": "multipart/mixed; boundary=%s" % boundary,
            "X-Request-Id": "%s" % get_random_number(6),
        }
        return requests.post(url, multipart, headers=headers)

    def store_mailish(self, json_body, rfc822_body, uid, external_imap_id, fid=INBOX_FID, request_id=_get_request_id()):
        url = "{base_url}/mail/store_mailish?uid={uid}&fid={fid}&" \
              "external_imap_id={external_imap_id}&request_id={request_id}" \
              .format(base_url=self._base_url,
                      uid=uid,
                      fid=fid,
                      external_imap_id=external_imap_id,
                      request_id=request_id)

        boundary, multipart = build_multipart(json.dumps(json_body), rfc822_body)
        headers = {
            "Content-Type": "multipart/mixed; boundary=%s" % boundary,
            "X-Request-Id": "%s" % get_random_number(6),
        }
        return requests.post(url, multipart, headers=headers)

    def send_mail(self, json_body, rfc822_body, uid, email,
                  detect_spam=False, detect_virus=False,  service="sendbernar", request_id=_get_request_id()):
        detect_spam = "1" if detect_spam else "0"
        detect_virus = "1" if detect_virus else "0"

        url = "{base_url}/mail/send_mail?uid={uid}&from_email={email}&service={service}&" \
              "detect_spam={detect_spam}&detect_virus={detect_virus}&request_id={request_id}" \
              .format(base_url=self._base_url,
                      uid=uid,
                      email=email,
                      service=service,
                      detect_spam=detect_spam,
                      detect_virus=detect_virus,
                      request_id=request_id)

        boundary, multipart = build_multipart(json.dumps(json_body), rfc822_body.as_string())
        headers = {"Content-Type": "multipart/mixed; boundary=%s" % boundary}
        return requests.post(url, multipart, headers=headers)
