from dns import resolver, reversename
from lib.settings import SETTINGS

FQDN_CLUSTERS = {}


def load_fqdn_clusters():
    global FQDN_CLUSTERS
    for cluster, qloud_envs in SETTINGS["qloud_cluster_dns_resolver"].iteritems():
        for qloud_env in qloud_envs:
            dns_resolver = resolver.Resolver()
            addresses = list(dns_resolver.query(qloud_env, "AAAA"))
            for addr in addresses:
                ipv6_reverse = reversename.from_address(addr.to_text())
                host_fqdn = dns_resolver.query(ipv6_reverse, "PTR")[0].to_text()[:-1]
                FQDN_CLUSTERS[host_fqdn] = cluster


def get_qloud_cluster(fqdn):
    if len(FQDN_CLUSTERS) == 0:
        load_fqdn_clusters()
    return FQDN_CLUSTERS.get(fqdn)
