from __future__ import unicode_literals
import re

from lib.settings import get_host, get_mx_type, get_mail_type
from lib.qloud_cluster_resolver import get_qloud_cluster

# C884742E0304
# 588E081245
PF_REGEX = re.compile(r"[A-Z0-9]{10,12}")
# tvLhzP32s2-ICKS2PVo
NW_OR_NSLS_REGEX = re.compile(r"[A-Za-z0-9]{10}-[A-Za-z0-9]{8}")


def get_cluster_name_for_qloud():
    # Handle qloud hosts like "sas1-85c0faa8b737.qloud-c.yandex.net"
    #  In tests it's a target host, so use arguments from command line
    cluster_name = get_mx_type()

    if cluster_name == "mxbackout":
        cluster_name = "mxback"

    if get_mail_type() == "corp":
        if cluster_name == "mxfront":
            return "mxcorp"
        return cluster_name + "corp"

    return cluster_name


def get_cluster_name(host_name):
    for cluster_name in ("mxbackcorp", "mxcorp", "smtpcorp", "forwardcorp",
                         "mxback", "mxfront", "yaback", "smtp", "outback", "forward", "postbackcorp", "postback"):
        if cluster_name in host_name:
            return cluster_name

    if "secure" in host_name:
        return "outback"

    if "ld.yandex.ru" in host_name:
        return "exchange"

    if host_name == get_host():
        return get_cluster_name_for_qloud()

    qloud_cluster = get_qloud_cluster(host_name)
    if qloud_cluster:
        return qloud_cluster

    raise RuntimeError("Unable to get cluster name for host=%s" % host_name)


def get_app_name(proto, session_id):
    if "ESMTP" in proto and PF_REGEX.match(session_id):
        return "PF"

    if "ESMTP" in proto and NW_OR_NSLS_REGEX.match(session_id):
        return "NW"

    if "LMTP" == proto and NW_OR_NSLS_REGEX.match(session_id):
        return "NSLS"

    if "Microsoft" in proto:
        return "NA"  # Unknown

    raise RuntimeError("Unable to get app name for session_id=%s and proto=%s" % (session_id, proto))


def parse_received_header(header_value):
    header_value = header_value.strip().replace("\r\n", "").replace("\t", " ")
    host = header_value.split("by ")[1].split(" ")[0]
    proto = header_value.split("by ")[1].split(" with ")[1].split(" id ")[0]
    session_id = None
    if " id " in header_value:
        session_id = header_value.split(" id ")[1].split(" ")[0].split(";")[0]

    re_header_value = re.compile(".*\\((?P<cluster>[a-z-]+)/Yandex\\).*")
    match = re_header_value.search(header_value)
    if match:
        cluster = match.group("cluster")
    else:
        cluster = get_cluster_name(host)

    return host, proto, session_id, cluster


def get_hop_info(header_value):
    host, proto, session_id, cluster = parse_received_header(header_value)
    return "%s(%s)" % (cluster, get_app_name(proto, session_id))
