import os
import yaml

from lib.utils import BASE_DIR


def _get_extension(path):
    ext = os.path.splitext(path)[-1]
    if not ext or ext[0] != ".":
        raise RuntimeError("Failed to extract extension from the given file path")
    return ext[1:]


_HANDLERS = {
    "yml": yaml.safe_load
}


def get_resource_file_as_dict(path):
    file = open(os.path.join(BASE_DIR, "resources", path))
    extension = _get_extension(path)
    if extension not in _HANDLERS:
        raise RuntimeError("No handlers found for extension '%s'" % extension)
    handler = _HANDLERS[extension]
    result = handler(file)
    if not isinstance(result, dict):
        raise RuntimeError("The result of handler invocation is not a dict instance")
    return result
