# -*- coding: utf-8 -*-

import json
import requests

from lib import ssh
from lib.cache import memoize
from lib.settings import SETTINGS

SHARPEI_URL = SETTINGS["sharpei"]["url"]
USE_SSH_PROXY = SETTINGS["sharpei"]["use_ssh_proxy"]

_cache = {}


@memoize(_cache)
def get_conninfo(uid, mode="master"):
    if USE_SSH_PROXY:
        return _get_conninfo_through_proxy(uid, mode)
    return _get_conninfo(uid, mode)


def _build_url(uid, mode):
    return "{url}/conninfo?uid={uid}&mode={mode}".format(url=SHARPEI_URL, uid=uid, mode=mode)


def _get_conninfo(uid, mode):
    resp = requests.get(_build_url(uid, mode))
    return resp.json()


def _get_conninfo_through_proxy(uid, mode):
    url = _build_url(uid, mode)
    cmd = "curl -s '{url}'".format(url=url)
    ssh_client = ssh.get_sshclient()
    stdout, _ = ssh.exec_command(ssh_client, cmd)
    return json.loads(stdout.read())
