# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import email
import requests

from lib import ssh
from lib.settings import SETTINGS

from urlparse import urljoin

STORAGE_URL = SETTINGS["storage"]["url"]
USE_SSH_PROXY = SETTINGS["storage"]["use_ssh_proxy"]
TIMEOUT = SETTINGS["storage"]["timeout"]


def _build_message_url(st_id):
    endpoint = "gate/get/{st_id}"
    return urljoin(
        STORAGE_URL,
        endpoint.format(st_id=st_id)
    )


def _get_message(st_id, start, finish):
    headers = []
    if start >= 0 and finish >= 0 and finish > start:
        headers = {"Range": "{start}-{finish}".format(start=start, finish=finish)}
    r = requests.get(_build_message_url(st_id), headers=headers, timeout=TIMEOUT)
    return r.text


def _get_message_through_proxy(st_id, start, finish):
    url = _build_message_url(st_id)
    range_param = ""
    if start >= 0 and finish >= 0 and finish > start:
        range_param = "--header 'Range: {start}-{finish}'".format(start=start, finish=finish)
    cmd = "curl --connect-timeout {timeout} -s {param} '{url}'".format(timeout=TIMEOUT, param=range_param, url=url)
    ssh_client = ssh.get_sshclient()
    stdout, _ = ssh.exec_command(ssh_client, cmd)
    return stdout.read()


def download_raw_message(st_id, start=0, finish=0):
    if USE_SSH_PROXY:
        return _get_message_through_proxy(st_id, start, finish)
    return _get_message(st_id, start, finish)


def download_message(st_id, start=0, finish=0):
    msg = download_raw_message(st_id, start, finish)
    return email.message_from_string(msg)
