# -*- coding: utf-8 -*-

import os
import yaml

from lib.settings import SETTINGS

USERS_FILE = SETTINGS["name_of_file_with_users"]

_users = None


class UserInfo(object):
    def __init__(self, email, pwd=None, uid=None, suid=None):
        self.email = email
        self.pwd = pwd
        self.uid = uid
        self.suid = suid

    @property
    def login(self):
        return self.email.split("@")[0]

    @property
    def domain(self):
        return self.email.split("@")[1]


def load_from_path(base_dir):
    global _users
    with open(os.path.join(base_dir, USERS_FILE), "r") as fd:
        _users = yaml.safe_load(fd)


def get_user(name):
    return UserInfo(**_users[name])


def get_users(*names):
    return map(get_user, names)
