# -*- coding: utf-8 -*-
import allure
import os
import time
import yaml

BASE_DIR = os.path.abspath(os.path.join(os.path.dirname(__file__), os.pardir))


def build_addr_spec(login, domain):
    return login + "@" + domain


def allure_attach(text, name):
    return allure.attach(name, text)


def build_multipart(json_part, rfc822_part, boundary="gc0pJq0M:08jU534c0p"):
    multipart = (
        "\r\n--" + boundary + "\r\n" +
        "Content-Type: application/json\r\n\r\n" +
        json_part +
        "\r\n--" + boundary + "\r\n" +
        "Content-Type: message/rfc822\r\n\r\n" +
        rfc822_part +
        "\r\n--" + boundary + "--\r\n")
    return boundary, multipart


def db_date_format_to_unix_timestamp(date):
    return int(time.mktime(date.timetuple()))


def get_description(category):
    with open(os.path.join(BASE_DIR, "fixtures", category + ".yaml")) as fd:
        return yaml.safe_load(fd)


def load_test_cases(category, case_info_cls):
    return [case_info_cls(name, **case_info) for name, case_info in
            get_description(category).iteritems()]


def get_letter_path(category, filename):
    return os.path.join(BASE_DIR, "fixtures", "emls", category, filename)
