# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import psycopg2

from lib import sharpei
from lib.settings import SETTINGS, get_mail_type
from library.python.vault_client.instances import Production as VaultClient

XDB_USER = SETTINGS["xdb"]["user"]
XDB_PWD = SETTINGS["xdb"]["pwd"]
PGPASS_VERSION = SETTINGS["pgpass"]["version"]


def setup_pwd():
    global XDB_PWD
    if XDB_PWD is not None:
        return
    client = VaultClient(decode_files=True)
    pgpass_secrets = client.get_version(PGPASS_VERSION)
    mail_type = get_mail_type()
    XDB_PWD = pgpass_secrets["value"][mail_type]


def fetch_all(uid, query):
    conn_string = _get_connection_string(sharpei.get_conninfo(uid))
    return _fetch_all(query, conn_string)


def fetch_one(uid, query):
    conn_string = _get_connection_string(sharpei.get_conninfo(uid))
    return _fetch_one(query, conn_string)


def decode_utf8(row):
    return [elem if not isinstance(elem, str) else str(elem).decode("utf-8") for elem in row]


def _fetch_all(query, conn_string):
    cursor = _execute_query(query, conn_string)
    return [decode_utf8(row) for row in cursor]


def _fetch_one(query, conn_string):
    rows = _fetch_all(query, conn_string)
    if rows:
        return rows[0]
    return None


def _execute_query(query, conn_string):
    conn = psycopg2.connect(conn_string)
    cursor = conn.cursor()
    cursor.execute(query)
    return cursor


def _get_connection_string(conninfo):
    shard = conninfo["addrs"][0]
    return (
        "host={host} port={port} "
        "dbname={dbname} user={user} password={pwd}"
    ).format(user=XDB_USER, pwd=XDB_PWD, **shard)
