# -*- coding: utf-8 -*-

from collections import Sequence


def mailbox(uid, mid):
    return """
        SELECT
            uid, mid, fid, tid, newest_tif, imap_id,
            revision, chain, seen, recent,
            deleted, received_date, to_json(lids), doom_date
        FROM
            mail.box
        WHERE
            uid={uid} AND mid={mid};""".format(uid=uid, mid=mid)


def deleted_box(uid, mid):
    return """
        SELECT
            deleted_date, uid, mid, revision, info
        FROM
            mail.deleted_box
        WHERE
            uid={uid} AND mid={mid};""".format(uid=uid, mid=mid)


def messages_by_field(uid, name, value):
    assert isinstance(value, (basestring, int))

    if isinstance(value, basestring):
        value = "'{0}'".format(value)

    query = """
        SELECT
            mid, st_id, size, attributes, to_json(attaches),
            subject, firstline, hdr_date, hdr_message_id,
            to_json(recipients), extra_data, pop_uidl, found_tid,
            thread_rule, mime
        FROM
            mail.messages
        WHERE
            uid={uid} AND {name}={value};"""
    return query.format(uid=uid, name=name, value=value)


def mail_labels_by_field(uid, name, value):
    assert isinstance(value, (basestring, int))

    if isinstance(value, basestring):
        value = "'{0}'".format(value)

    query = """
        SELECT
            lid, name, type, color, created, message_count
        FROM
            mail.labels
        WHERE
            uid={uid} AND {name}={value};"""
    return query.format(uid=uid, name=name, value=value)


def mail_labels_by_fields(uid, name, values):
    assert isinstance(values, Sequence)
    assert len(values) >= 1

    values_list = ", ".join(str(value) if isinstance(value, int) else "'{0}'".format(value) for value in values)

    query = """
        SELECT
            lid, name, type, color, created, message_count
        FROM
            mail.labels
        WHERE
            uid={uid} AND {name} IN ({values_list});"""
    return query.format(uid=uid, name=name, values_list=values_list)


def several_mail_labels(uid, count):
    query = """
        SELECT
            lid, name, type, color, created, message_count
        FROM
            mail.labels
        WHERE
            uid={uid}
        LIMIT
            {limit};"""
    return query.format(uid=uid, limit=count)


def mail_folders_by_fields(**fields):
    conditions = []
    for key, value in fields.items():
        if isinstance(value, int):
            conditions.append("{0}={1}".format(key, value))
        if isinstance(value, basestring):
            conditions.append("{0}='{1}'".format(key, value))
        if value is None:
            conditions.append("{0} IS NULL".format(key))

    query = """
        SELECT
            fid, revision, name, parent_fid, type, unvisited,
            unique_type, created, next_imap_id,
            uidvalidity, first_unseen, first_unseen_id,
            message_count, message_seen, message_size,
            message_recent, attach_count, attach_size,
            pop3state, position, subscribed_for_shared_folder
        FROM
            mail.folders
        WHERE
            {where};"""
    return query.format(where=" AND ".join(conditions))


def mail_changelog_entry_by_mid(uid, mid):
    query = """
        SELECT
            cid, uid, revision, type, change_date, changed, arguments,
            fresh_count, useful_new_count, db_user, x_request_id, session_key, quiet
        FROM
            mail.change_log
        WHERE
            uid={uid} AND changed @> '[{{ "mid": {mid} }}]';"""
    return query.format(uid=uid, mid=mid)


def mailish_message_by_mid(uid, mid):
    query = """
        SELECT
            uid, fid, imap_id, imap_time, mid, errors
        FROM
            mailish.messages
        WHERE
            uid={uid} AND mid={mid};"""
    return query.format(uid=uid, mid=mid)
